﻿IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CP_Cbtes_Rec_Generar_Item]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CP_Cbtes_Rec_Generar_Item] 
END
GO

CREATE PROCEDURE [dbo].[CP_Cbtes_Rec_Generar_Item]
@pId_Trans				INT,
@pItem					SMALLINT,
@pId_Producto			VARCHAR(14),
@pCantidad				DECIMAL(15,5),
@pId_Trans_A_Cancelar	INT,
@pImporte_A_Cancelar	DECIMAL(16,2)
AS
SET NOCOUNT ON

/*Declaracion Variables Locales*/
DECLARE @Id_Estado_Cbte SMALLINT
DECLARE @Calle CHAR(3)
DECLARE @Columna CHAR(3)
DECLARE @Fila CHAR(3)
DECLARE @Bultos DECIMAL(15,5)
DECLARE @Despacho VARCHAR(100)
DECLARE @Serie VARCHAR(100)
DECLARE @Fecha_Venc DATETIME
DECLARE @Observacion VARCHAR(8000)
DECLARE @Millas INT
DECLARE @Cantidad_Saldo DECIMAL(15,5)
DECLARE @Precio_Grav DECIMAL(15,5)
DECLARE @Precio_Exen DECIMAL(15,5)
DECLARE @Imp_Gravado DECIMAL(12,2)
DECLARE @Imp_Exento DECIMAL(12,2)
DECLARE @Analisis VARCHAR(30)
DECLARE @Lote VARCHAR(20)
DECLARE @Flag_QA CHAR(1)
DECLARE @Fecha_QA DATETIME
DECLARE @Porc_Iva DECIMAL(5,2)
DECLARE @Bonif DECIMAL(5,2)
DECLARE @Descripcion_producto VARCHAR(100)
DECLARE @Id_Unidad_Medida CHAR(4)
DECLARE @Imp_Final DECIMAL(15,5)
DECLARE @Costo DECIMAL(15,5)
DECLARE @Imp_Iva DECIMAL(12,2)
DECLARE @Precio DECIMAL(15,5)
DECLARE @Id_Costo INT
DECLARE @Id_Cliente INT
DECLARE @Id_Tarea SMALLINT
DECLARE @Fecha_Caducidad DATETIME
DECLARE @Id_Pais CHAR(3)
DECLARE @Id_Usuario SMALLINT
DECLARE @CANTIDAD_EQUIV DECIMAL(15,5)
DECLARE @Costo_MO DECIMAL(15,5)
DECLARE @Costo_GF DECIMAL(15,5)
DECLARE @Id_Cond_Pago SMALLINT
DECLARE @Fecha_Proceso DATETIME
DECLARE @Id_Balanza CHAR(10)
DECLARE @Orden SMALLINT
DECLARE @Flag_NoImp_Factura TINYINT
DECLARE @Nro_Tag VARCHAR(30)
DECLARE @Fecha_Elaboracion DATETIME
DECLARE @Costo_Comparativo DECIMAL(13,4)
DECLARE @Id_Cta_Banco SMALLINT
DECLARE @Porc_Imp_INT DECIMAL(5,2)

DECLARE @Nro_Cuota			SMALLINT
DECLARE @Id_Empresa			SMALLINT
DECLARE @Id_Cliente_Cab		INT
DECLARE @Fecha_Vence		DATETIME
DECLARE @Descripcion		VARCHAR(100)
DECLARE @Importe			DECIMAL(12,2)
DECLARE @Nro_Cuota_Origen	SMALLINT
DECLARE @Id_Moneda			CHAR(3)
DECLARE @Saldo				DECIMAL(12,2)
DECLARE @Nro_FacCre			INT

DECLARE @Flag_Existe_Producto	TINYINT

DECLARE @Id_Tipo_Cbte		CHAR(4)
DECLARE @Fecha				DATETIME

DECLARE @Item				SMALLINT
DECLARE @Item_D				SMALLINT
DECLARE @Cantidad			DECIMAL(14, 2)
DECLARE @Fecha_Aplic		DATETIME

DECLARE @Id_Estado_Cbte_Id_Trans_Origen SMALLINT
DECLARE @Id_Trans_Origen	INT
DECLARE @Id_Trans_CA		INT
DECLARE @Saldo_Cbte			DECIMAL(16,2)

DECLARE @Mensaje			VARCHAR(100)
/*Fin de Declaraciones Variables Locales */

PRINT 'Procedimiento: CP_Cbtes_Rec_Generar_Item Trans: '+ CAST(@pId_Trans AS VARCHAR(10))

BEGIN TRY
	BEGIN TRAN

	SET @Flag_Existe_Producto = ISNULL((SELECT 1 FROM Productos WHERE Id_Producto = @pId_Producto), 0)
	IF (@Flag_Existe_Producto = 0)
	BEGIN
		SET @Mensaje = 'No existe el Producto'

		SELECT	3001			AS ErrorNumber 
				,0				AS ErrorSeverity  
				,0				AS ErrorState 
				,0				AS ErrorProcedure  
				,0				AS ErrorLine		
				,@Mensaje		AS ErrorMessage
				,@pId_Trans		AS Id_Trans
		ROLLBACK
		RETURN 3001
	END

	/*************************************************************************************************/

	SELECT  @Id_Tipo_Cbte	= ISNULL(Id_Tipo_Cbte, ''),
			@Fecha			= ISNULL(Fecha, '19000101'),
			@Id_Cliente_Cab = ISNULL(Id_Cliente, 0),
			@Id_Moneda		= Id_Moneda
	FROM Cbtes
	WHERE 
	Id_Trans = @pId_Trans

	/*************************************************************************************************/

	SELECT  @Id_Estado_Cbte	= ISNULL(Id_Estado_Cbte_Item, 0) FROM Cbtes_Tipos  WHERE Id_Tipo_Cbte = @Id_Tipo_Cbte

	/*************************************************************************************************/

	SELECT  @Calle		= ISNULL(Calle, ''),
			@Columna	= ISNULL(Columna, ''),
			@Fila		= ISNULL(Fila, ''),
			@Despacho	= ISNULL(Despacho, '') --Toma Null
	FROM Productos
	WHERE 
	Id_Producto = @pId_Producto

	/*************************************************************************************************/
	
	SELECT @Id_Estado_Cbte_Id_Trans_Origen = ISNULL(Id_Estado_Cbte, 0), @Saldo_Cbte = Saldo 	FROM Cbtes 	WHERE 	Id_Trans = @pId_Trans_A_Cancelar

	/*************************************************************************************************/
	
	IF(@Id_Estado_Cbte_Id_Trans_Origen IN (1,4) /*Pendiente*/)
	BEGIN
		SET @Fecha_Venc = @Fecha
		SET @Observacion = (dbo.CF_Cbte_Descrip(@pId_Trans_A_Cancelar))
		SET @Imp_Gravado = @pImporte_A_Cancelar
		/*TO-DO: De aca para abajo por ahora por Default*/
		SET @Bultos = 0
		SET @Serie = ''
		SET @Millas = 0
		SET @Cantidad_Saldo = 0
		SET @Precio_Grav = 0
		SET @Precio_Exen = 0	
		SET @Imp_Exento = 0
		SET @Analisis = ''
		SET @Lote = ''
		SET @Flag_QA = ''
		--SET @Fecha_QA = NULL
		SET @Porc_Iva = 0
		SET @Bonif = 0
		SET @Descripcion_producto = (dbo.CF_Cbte_Descrip(@pId_Trans_A_Cancelar))
		SET @Id_Unidad_Medida = ''
		SET @Imp_Final = 0
		SET @Costo = 0
		SET @Imp_Iva = 0
		SET @Precio = 0
		SET @Id_Costo = 0
		SET @Id_Cliente = 0
		SET @Id_Tarea = 0
		--SET @Fecha_Caducidad = NULL
		SET @Id_Pais = ''
		SET @Id_Usuario = 0
		SET @Cantidad_Equiv = 0
		SET @Costo_MO = 0
		SET @Costo_GF = 0
		SET @Id_Cond_Pago = 0
		--SET @Fecha_Proceso NULL
		SET @Id_Balanza = ''
		SET @Orden = 0
		SET @Flag_NoImp_Factura = 0
		SET @Nro_Tag = ''
		--SET @Fecha_Elaboracion = NULL
		SET @Costo_Comparativo = 0
		SET @Id_Cta_Banco = 0
		SET @Porc_Imp_Int = 0

		
		INSERT INTO dbo.Cbtes_Items
		(Id_Trans,		Item,				Id_Producto,
		Id_Estado_Cbte,	Cantidad,			Calle,
		Columna,		Fila,				Bultos,
		Despacho,		Serie,				Fecha_Venc,
		Observacion,	Millas,				Cantidad_Saldo,
		Precio_Grav,	Precio_Exen,		Imp_Gravado,
		Imp_Exento,		Analisis,			Lote,
		Flag_QA,		Fecha_QA,			Porc_Iva,
		Bonif,			Descripcion_producto,Id_Unidad_Medida,
		Imp_Final,		Costo,				Imp_Iva,
		Precio,			Id_Costo,			Id_Cliente,
		Id_Tarea,		Fecha_Caducidad,	Id_Pais,
		Id_Usuario,		Cantidad_Equiv,		Costo_MO,
		Costo_GF,		Id_Cond_Pago,		Fecha_Proceso,
		Id_Balanza,		Orden,				Flag_NoImp_Factura,
		Nro_Tag,		Fecha_Elaboracion,	Costo_Comparativo,
		Id_Cta_Banco,	Porc_Imp_Int)
		VALUES
		(@pId_Trans,	@pItem,				@pId_Producto,
		@Id_Estado_Cbte,@pCantidad,			@Calle,
		@Columna,		@Fila,				@Bultos,
		@Despacho,		@Serie,				@Fecha_Venc,
		@Observacion,	@Millas,			@Cantidad_Saldo,
		@Precio_Grav,	@Precio_Exen,		@Imp_Gravado,
		@Imp_Exento,	@Analisis,			@Lote,
		@Flag_QA,		@Fecha_QA,			@Porc_Iva,
		@Bonif,			@Descripcion_producto,@Id_Unidad_Medida,
		@Imp_Final,		@Costo,				@Imp_Iva,
		@Precio,		@Id_Costo,			@Id_Cliente,
		@Id_Tarea,		@Fecha_Caducidad,	@Id_Pais,
		@Id_Usuario,	@Cantidad_Equiv,	@Costo_MO,
		@Costo_GF,		@Id_Cond_Pago,		@Fecha_Proceso,
		@Id_Balanza,	@Orden,				@Flag_NoImp_Factura,
		@Nro_Tag,		@Fecha_Elaboracion,	@Costo_Comparativo,
		@Id_Cta_Banco,	@Porc_Imp_Int)
	END

	/*****************************************************************************/
	
	SET @Nro_Cuota		= @pItem
	--SET @Id_Empresa NULL
	SET @Fecha_Vence	= @Fecha
	SET @Descripcion	= dbo.CF_Cbte_Descrip(@pId_Trans)
	SET @Importe		= (@pImporte_A_Cancelar * (-1))
	SET @Id_Estado_Cbte = 0 --En Carga
	SET @Observacion	= ''
	SET @Saldo			= @Importe
	SET @Nro_FacCre		= 0
	
	IF(@Id_Estado_Cbte_Id_Trans_Origen IN (1,4)/*Pendiente*/)
	BEGIN
		SET @Id_Trans_Origen = @pId_Trans_A_Cancelar
		SET @Nro_Cuota_Origen = 1
	END
	ELSE
	BEGIN
		SET @Id_Trans_Origen = 0
		SET @Nro_Cuota_Origen = 0
	END

	INSERT INTO dbo.Clientes_CtaCte
		(Id_Trans,		Nro_Cuota,			Id_Empresa,
		Id_Cliente,		Fecha,				Fecha_Vence,
		Descripcion,	Importe,			Id_Estado_Cbte,
		Observacion,	Id_Trans_Origen,	Nro_Cuota_Origen,
		Id_Moneda,		Saldo,				Nro_FacCre)
		VALUES
		(@pId_Trans,	@Nro_Cuota,				@Id_Empresa,
		@Id_Cliente_Cab,@Fecha,					@Fecha_Vence,
		@Descripcion,	@Importe,				@Id_Estado_Cbte,
		@Observacion,	@Id_Trans_Origen,		@Nro_Cuota_Origen,
		@Id_Moneda,		@Saldo,					@Nro_FacCre)

	/*****************************************************************************/

	
	SET @Item_D = 1
	SET @Cantidad = 0
	--SET @Fecha_Aplic = GETDATE() NULL
	
	IF(@Id_Estado_Cbte_Id_Trans_Origen IN (1,4) /*Pendiente*/)
	BEGIN
		SET @Id_Trans_CA = @pId_Trans_A_Cancelar
		SET @Item = 1
	END
	ELSE
	BEGIN
		SET @Id_Trans_CA = 0
		SET @Item = 0
	END
	IF NOT EXISTS (SELECT 1 FROM Cbtes_Aplica WHERE Id_Trans = @Id_Trans_CA
				AND	Item = @Item
				AND	Id_Trans_D = @pId_Trans
				AND	Item_D = @Item_D)
    BEGIN
		INSERT INTO dbo.Cbtes_Aplica
		(Id_Trans,		Item,		Id_Trans_D,
		Item_D,			Cantidad,	Importe,
		Fecha_Aplic)
		VALUES
		(@Id_Trans_CA,		@Item,			@pId_Trans,
		@Item_D,			@Cantidad,		@pImporte_A_Cancelar ,
		@Fecha_Aplic)
    END
	ELSE
	BEGIN
		UPDATE Cbtes_Aplica
		SET Importe = Importe +  @pImporte_A_Cancelar
		WHERE Id_Trans = @Id_Trans_CA
				AND	Item = @Item
				AND	Id_Trans_D = @pId_Trans
				AND	Item_D = @Item_D
	END
	/*****************************************************************************/
	
	IF(@Id_Estado_Cbte_Id_Trans_Origen IN (1,4)/*Pendiente*/)
	BEGIN
	    IF @Saldo_Cbte - ABS(@pImporte_A_Cancelar) <= 0
		BEGIN
			UPDATE Cbtes SET Id_Estado_Cbte = 2, Saldo = 0 WHERE Id_Trans = @pId_Trans_A_Cancelar
			UPDATE Cbtes_Items SET Id_Estado_Cbte = 2 WHERE Id_Trans = @pId_Trans_A_Cancelar
			UPDATE Clientes_CtaCte SET Id_Estado_Cbte = 2, Saldo = 0 WHERE Id_Trans = @pId_Trans_A_Cancelar
        END
		ELSE
		BEGIN
			UPDATE Cbtes SET Id_Estado_Cbte = 4, Saldo = Saldo - ABS(@pImporte_A_Cancelar) WHERE Id_Trans = @pId_Trans_A_Cancelar
			UPDATE Cbtes_Items SET Id_Estado_Cbte = 4 WHERE Id_Trans = @pId_Trans_A_Cancelar
			UPDATE Clientes_CtaCte SET Id_Estado_Cbte = 4, Saldo = Saldo - @pImporte_A_Cancelar WHERE Id_Trans = @pId_Trans_A_Cancelar

		END
	END
	/*****************************************************************************/

	COMMIT

	SELECT	 0				AS ErrorNumber 
			,0				AS ErrorSeverity  
			,0				AS ErrorState 
			,0				AS ErrorProcedure  
			,0				AS ErrorLine		
			,@Mensaje		AS ErrorMessage
			,@pId_Trans		AS Id_Trans

END TRY  


BEGIN CATCH  
    SELECT  
		ERROR_NUMBER() AS ErrorNumber  
		,ERROR_SEVERITY() AS ErrorSeverity  
		,ERROR_STATE() AS ErrorState  
		,ERROR_PROCEDURE() AS ErrorProcedure  
		,ERROR_LINE() AS ErrorLine  
		,ERROR_MESSAGE() AS ErrorMessage
		,@pId_Trans		AS Id_Trans
	   
	ROLLBACK
	RETURN 9999
END CATCH

PRINT 'FIN Procedimiento: CP_Cbtes_Rec_Generar_Item Trans: '+ CAST(@pId_Trans AS VARCHAR(10))
RETURN 0
